unit UserTemplates;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  extctrls;

type
  TUserTemplatesDialog = class(TForm)
    procedure FormShow(Sender: TObject);
    procedure PanelClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  UserTemplatesDialog: TUserTemplatesDialog;

implementation

{$R *.DFM}

uses Frame, TemplateDlg;

procedure TUserTemplatesDialog.FormShow(Sender: TObject);
var i: integer;
    panel: TPanel;
    h, b1w, b2w: integer;
begin
  UserTemplatesDialog.DestroyComponents;
  UserTemplatesDialog.Font.Style := [fsBold];
  UserTemplatesDialog.Canvas.Font.Style := [fsBold];
  h := UserTemplatesDialog.Canvas.TextHeight('g') + 8;
  b1w := UserTemplatesDialog.Canvas.TextWidth('1');
  b2w := UserTemplatesDialog.Canvas.TextWidth('12: ') -
         UserTemplatesDialog.Canvas.TextWidth('   ');
  for i := 0 to TemplateDialog.names.Count - 1 do
  begin
    panel := TPanel.Create(self);
    case i of
      0..8 : begin
               panel.Caption := IntToStr(i+1) + ': ' + TemplateDialog.names[i];
               panel.BorderWidth := 4 + b1w;
             end;
      9..11: begin
               panel.Caption := IntToStr(i+1) + ': ' + TemplateDialog.names[i];
               panel.BorderWidth := 4;
             end;
      else   begin
               panel.Caption := '   ' + TemplateDialog.names[i];
               panel.BorderWidth := 4 + b2w;
             end;
    end;
    panel.Tag := i;
    panel.OnClick := PanelClick;
    Panel.Width := UserTemplatesDialog.ClientWidth;
    Panel.Top := i*h;
    Panel.Height := h;
    Panel.Alignment := taLeftJustify;
//    Panel.BorderWidth := 4;
    Panel.Parent := UserTemplatesDialog;
  end;
end;

procedure TUserTemplatesDialog.PanelClick(Sender: TObject);
var Idx: integer;
begin
  FrameForm.SetFocus;
  Idx := (Sender as TPanel).Tag;
  FrameForm.InsertText(TemplateDialog.parts1[Idx], TemplateDialog.parts2[Idx]);
end;

procedure TUserTemplatesDialog.FormResize(Sender: TObject);
var i: integer;
begin
  for i := 0 to UserTemplatesDialog.ControlCount - 1 do
    UserTemplatesDialog.Controls[i].Width := UserTemplatesDialog.ClientWidth;
end;

procedure TUserTemplatesDialog.FormClick(Sender: TObject);
begin
  FrameForm.SetFocus;
end;

end.
