$! VMSBUILD.COM         Build the Funnelweb program under VMS
$!
$!      J Begg  VSM Software Services   11-Feb-1992     jeremy@vsm.com.au
$!
$! set verify
$       set noon
$       say     = "write sys$output"
$       sts     = 1
$
$!
$! Make sure we are in the sources directory -- Assumes this procedure is in
$! the same directory as the sources.
$!
$       cur_def = f$env("DEFAULT")
$       proc    = f$env("PROCEDURE")
$       procnam = proc - f$parse(proc,,,"VERSION")
$       procdir = proc - f$parse(proc,,,"NAME")    -
                       - f$parse(proc,,,"TYPE")    -
                       - f$parse(proc,,,"VERSION")
$       sourcedir = procdir - "ADMIN]" + "SOURCES]"
$       if f$search(sourcedir+"WEAVE.C").eqs.""
$       then
$           say "It would appear that the FunnelWeb sources have not been"
$           say "loaded into the correct directory.  Please move them into"
$           say "       ", procdir
$           say "then re-execute this procedure."
$           goto Exit
$       endif
$
$       set default 'sourcedir'

$       show default
$
$!
$! Check for VAX C, use GNU C if VAX C is not found
$!
$       if f$search("SYS$SYSTEM:VAXC.EXE").nes.""
$       then
$           say "   Using VAX C.  If you prefer to use GNU C, edit the file"
$           say "   ",procnam
$           say "   as instructed therein."
$           use_VAXC = "true"
$       else
$           say "   VAX C not found -- using GNU C."
$           use_VAXC = "false"
$       endif
$
$!*************************************************************************
$! UNCOMMENT the following line to force use of VAX C                    !*
$!      use_VAXC = "true"                                                !*
$! UNCOMMENT the following line to force use of GNU C                    !*
$!      use_VAXC = "false"                                               !*
$!*************************************************************************
$!
$! Set up the appropriate symbols
$!
$       if use_VAXC
$       then
$           cc = "CC"
$           cflags = "/DEBUG/WARN/NOOPT/LIST"
$       else
$           cc = "GCC"
$           cflags = " -g -Wall"
$       endif
$
$       link = "link"
$
$!
$! An object library is used to hold .OBJ files along the way.
$!
$       if f$search("FUNNELWEB.OLB").eqs."" then $ lib/cre/obj funnelweb.olb
$
$ if "''p1'" .eqs. "LINK" then $ goto Done_Compile
$!
$! Search for .C files, compiling same.
$!
$       old_src = ""
$       filecount = 0
$       skiptofile = ""
$       if "''p1'" .nes. ""
$       then
$          skiptofile = "$USERS:[ROSS.FWDIR.SOURCES]''p1'"
$       endif
$Compile:
$       src = f$search("*.C")
$       if src.eqs."" then $ goto Done_Compile
$       if src.eqs.old_src then $ goto Done_Compile
$       srcnam = src - f$parse(src,,,"TYPE") - f$parse(src,,,"VERSION")
$       if srcnam .lts. skiptofile
$       then
$          write sys$output "Skipping ''srcnam'"
$          goto Compile
$       endif
$       say "Compiling ",srcnam
$       'cc 'cflags 'srcnam
$       if .not.$status then $ goto Compile_Failed
$       lib/repl funnelweb 'srcnam
$       deletx 'srcnam'.obj;
$       goto Compile
$
$Compile_Failed:
$       sts = $status
$       say "Build of FunnelWeb aborted because compile failed for file:"
$       say src
$       goto Exit
$
$Done_Compile:
$       say "Linking..."
$       cur_exe = f$search("FUNNELWEB.EXE")
$       !Jeremy's link: link/debug/map/full funnelweb/opt
$       link funnelweb/library/include=main,sys$input:/opt/exe='procdir'fw.exe
sys$share:vaxcrtl/share
$       if $status then $ goto Exit
$       sts = $status
$       say "Build of FunnelWeb aborted in Link phase"
$       if f$search("FUNNELWEB.EXE").nes.cur_exe then $ delete funnelweb.exe;
$
$Exit:
$       set default 'cur_def'
$       exit sts
