/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  T_enum_phrase_th.lex
Dates:		  22 Mar 2004
Purpose:	  parse T-enumeration phrase
Output:       T_enum_phrase
*/
/@
@i "/yacco2/copyright.w"
@** |T_enum_phrase_th| Thread.\fbreak
parse T-enumeration phrase.
@/
fsm	
(fsm-id "T_enum_phrase_th.lex"
,fsm-filename T_enum_phrase_th
,fsm-namespace NS_T_enum_phrase_th
,fsm-class CT_enum_phrase_th{
  user-prefix-declaration
#include "lint_balls.h"
#include "eol.h"
#include "c_comments.h"
#include "identifier.h"
#include "c_string.h"
#include "o2_sdc.h"
    using namespace NS_yacco2_terminals;
  ***
  user-declaration
    public:
    T_enum_phrase* enum_phrase_;
  ***
  op
    if(enum_phrase_ != 0){
      delete enum_phrase_;
      enum_phrase_ = 0;
    }
    enum_phrase_ = new T_enum_phrase;
    enum_phrase_->set_rc(*parser__->start_token__,__FILE__,__LINE__);
    AST* t = new AST(*enum_phrase_);
    enum_phrase_->phrase_tree(t);
  ***
  constructor
      enum_phrase_ = 0;
  ***
}
,fsm-version "1.0",fsm-date "22 mar 2004",fsm-debug "false"
,fsm-comments "Parse ``T-enumeration'' construct: Time out smell the tullips.")
parallel-parser	
(	
  parallel-thread-function
    TH_T_enum_phrase_th
  ***
  parallel-la-boundary
    eolr
  ***
)
@"/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
RT_enum_phrase (){
  -> Rlint 
     Ropen_par 
       Rparameters  
     Rclose_par
     Rlint 
     Rk_defs_phrase
     Rlint  {
    op
      CT_enum_phrase_th* fsm = (CT_enum_phrase_th*)rule_info__.parser__->fsm_tbl__;
      RSVP(fsm->enum_phrase_);
      fsm->enum_phrase_ = 0;
    ***
    }	
}

Ropen_par (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_open_parenthesis;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  "("
}

Rclose_par (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_close_parenthesis;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  ")"
}

Rparameters (){
  -> Rlint
     Rfilename_phrase Rlint
     Rnamespace_phrase Rlint
}

Rfilename_phrase (){
  -> Rfilename Rlint Rfilename_id
}

Rfilename (){
  ->  ||| "#file-name" NS_identifier::TH_identifier
  ->  ||| |?| NULL {
    op
      sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_no_filename_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_filename_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfilename_id (){
  ->  ||| identifier NS_identifier::TH_identifier {
      op
        CT_enum_phrase_th* fsm = (CT_enum_phrase_th*)rule_info__.parser__->fsm_tbl__;
        fsm->enum_phrase_->filename_id(sf->p2__);
      ***
      } 
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_filename_id_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rnamespace_phrase  (){
  -> "," Rlint Rnamespace Rlint Rnamespace_id 
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_comma_present;
        sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rnamespace  (){
  ->  ||| "#name-space" NS_identifier::TH_identifier 
  ->  ||| |?| NULL {
    op
       sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_no_namespace_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_namespace_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rnamespace_id  (){
  ->  ||| identifier NS_identifier::TH_identifier {
      op
        CT_enum_phrase_th* fsm = (CT_enum_phrase_th*)rule_info__.parser__->fsm_tbl__;
        fsm->enum_phrase_->namespace_id(sf->p2__);
      ***
      } 
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_namespace_id_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rk_defs_phrase  (){
  -> "{" Rlint Rconstant_epi_defs Rlint Rclose_brace 
}

Rconstant_epi_defs  (){
  ->  Rconstant_defs Rconstant_defs_code
  -> 
}
Rconstant_defs  (){
  ->  ||| "#constant-defs" NS_identifier::TH_identifier {
    op
       sf->p2__->set_auto_delete(true);
    ***
    }
  ->  ||| |?| NULL {
    op
        RSVP(sf->p2__);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
}

Rconstant_defs_code  (){
  ->  ||| "syntax-code" NS_o2_sdc::TH_o2_sdc {
    op
      CT_enum_phrase_th* fsm = (CT_enum_phrase_th*)rule_info__.parser__->fsm_tbl__;
      fsm->enum_phrase_->kdefs(sf->p2__);
    ***
    }
  ->  ||| |?| NULL {// error from syntax code thread
    op
        CAbs_lr1_sym* sym = new Err_no_kdefs_code_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
         sf->p2__->set_auto_delete(true);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_kdefs_code_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rclose_brace  (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_close_brace;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  "}"
}

Rlint  (){
  ->  ||| lint NS_lint_balls::TH_lint_balls
  -> 
}
}// end of rules
