/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  lint_balls.lex
Dates:		  24 May 2004
Purpose:	  vacuums the non essential stuff.
parse terminals phrase
Output:       T_lint
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |lint_balls_th| thread.\fbreak
Rip thru the white stuff and the comments.
Why this thread anyway?
I'd rather have 1 place to deal with a slight overhead of
a thread calling a thread.
Overall the code bloat will go down instead of 
having it programmed per
grammar.
The |T_lint| terminal is returned.
Use a global pointer to it as it is just an indicator.
The new / delete cycle is too expensive.

@/
fsm	
(fsm-id "lint_balls.lex"
,fsm-filename lint_balls
,fsm-namespace NS_lint_balls
,fsm-class Clint_balls{
  user-prefix-declaration
#include "eol.h"
#include "ws.h"
#include "c_comments.h"
  ***
}
,fsm-version "1.0",fsm-date "22 mar 2004",fsm-debug "false"
,fsm-comments "Is this spring cleaning?")
parallel-parser	
(	
  parallel-thread-function
    TH_lint_balls
  ***
  parallel-la-boundary
    eolr
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rlint_balls  (){
  -> Rlint {
  op
        CAbs_lr1_sym* sym = NS_yacco2_terminals::PTR_lint__;
        sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
        RSVP(sym);
  ***
  }
}

Rlint  
/@
Why the use of \invisibleshift? 
To reduce the lookahead set size.
|eolr| is only one entry in the lookahead
instead of expressing the specifics.
@/

(){
  -> Rfluffs |.| 
}

Rfluffs  (){
  ->  Rfluff
  ->  Rfluffs Rfluff
}

Rfluff  (){
  ->  ||| ws NS_ws::TH_ws 
  ->  ||| comment NS_c_comments::TH_c_comments {
      op
        sf->p2__->set_auto_delete(true);
      ***
      }
  ->  ||| |?| NULL {
      op
        RSVP(sf->p2__);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  ||| eol NS_eol::TH_eol
}
}// end of rules
