/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		ws.lex
Date:	  	17 Juin 2003
Purpose:	white space lexer
Conduit:	ws
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |ws| Thread.\fbreak
White space globber of:\fbreak
\ptindent{1) \] ---  space}
\ptindent{2) horizontal tab}
\ptindent{3) vertical tab}
\ptindent{4) form feed}
Use a global pointer to it as it is just an indicator.
The new / delete cycle is too expensive.

As the data accepted is not needed, i skip building up its characters
in a local string.
@/
fsm	
(fsm-id "ws.lex",fsm-filename ws,fsm-namespace NS_ws
,fsm-class Cws{
  user-declaration
    public:
       void read_white_stuff();
  ***
  user-implementation
       void Cws::read_white_stuff(){
loop:
	  switch (parser__->current_token()->enumerated_id__){
	  case T_Enum::T_raw_sp_: goto other;
	  case T_Enum::T_raw_ht_: goto other;
	  case T_Enum::T_raw_vt_: goto other;
	  case T_Enum::T_raw_ff_: goto other;	
          default: return;
          }
    other:{
          parser__->get_next_token();
goto loop;
      }

        }
  ***
  }
,fsm-version "1.0",fsm-date "17 Juin 2003",fsm-debug "false",fsm-comments "White space globber.")
parallel-parser	
(	
  parallel-thread-function
    TH_ws
  ***
  parallel-la-boundary
    eolr
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rws (){
  -> Rchr |.|{
  op
    Cws* fsm = (Cws*) rule_info__.parser__->fsm_tbl__;
    CAbs_lr1_sym* sym = NS_yacco2_terminals::PTR_ws__;
    sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
     sym->set_line_no_and_pos_in_line(*rule_info__.parser__->start_token__);
    RSVP(sym);
  ***
  }
}

Rchr	(
lhs{
/@
Why the previous stack frame?
Cuz the finite state implementation has the
vectoring symbol associated with its state and
the current stack frame is its goto state 
with no associated symbol.

Why the delayed grabbing of the character here instead of 
at its subrule?
To prevent code bloat and to improvize.
@/
  op
    Cws* fsm = (Cws*) rule_info__.parser__->fsm_tbl__;
    fsm->read_white_stuff();// current token is the next character to assess
  ***
  }
){
  -> 	
    /@
The white space is dotted in the 
diagram due to |convertMPtoPDF| limitations.   
    @/

" " 
  -> 	"x09" // ht
  -> 	"x0b" // vt
  -> 	"x0c" // ff
}
}// end of rules
